
binAdjustPformMQ <- function(dataf){
  
  PTMscore <- dataf
  
  PTMscore$Peptidoform <- paste0( PTMscore$Modified.sequence,"_", PTMscore$PTM.positions)
  
  PTMscore$PROTEIN_LOC <- paste0(PTMscore$Protein,"_",PTMscore$PROTEIN_POS_NUM)
  

  
  PTMscore <- PTMscore %>% dplyr::rename("PROTEIN_beg" = "PRO_Start",
                                   "PROTEIN_end" = "PRO_End")
  
  PTM2<- PTMscore %>% group_by(PROTEIN_LOC) %>% dplyr::mutate(count_S = n())
  
  
  
  # Number of different possibilities to be observed N #
  
  PTM3 <- FFreqMQ(PTM2)
  
  PTM3$SpectA<- as.character(gregexpr(pattern ='A\\(P',PTM3$Modified.sequence))
  
  PTM3$Num_As <-ifelse( PTM3$SpectA=='-1',0,1)
  
  PTM2Unique <- PTM3 %>% dplyr::arrange(Unique_scan) %>% distinct(Unique_scan, .keep_all = TRUE) %>% ungroup()
  
  
  
  PTM3$probChance3 <-sum(PTM2Unique$Num_As)/length(PTM2Unique$Unique_scan)
  
  
  # Calculation of binomial prob #
  
  
  PTM3$bioprob3 <- dbinom(PTM3$count_S, PTM3$N_Count, PTM3$probChance3)
  
  # Combine as independent p1*(1-P2) #
  PTM3$PTM_final_prob <- (1-PTM3$PEP)*PTM3$PTM_Prob
  
  PTM3$Bin_Adjusted_Score <- (1-PTM3$bioprob3)*PTM3$PTM_final_prob
  
  
  BinomialSet3 <- PTM3 %>% group_by(Peptidoform) %>% top_n(1, Bin_Adjusted_Score)
  
  BinomialSet <- subset(BinomialSet3,select = c(Unique_scan,Sequence,Bin_Adjusted_Score,Peptidoform))
  
  PTMscore <- subset(PTMscore,select = -c(Unique_scan,Sequence))
  
  total <- merge(PTMscore,BinomialSet,by="Peptidoform")
  
  
  ReducedTable2 <- total %>% dplyr::arrange(Peptidoform) %>% distinct(Peptidoform, .keep_all = TRUE) %>% ungroup()
  

return(ReducedTable2)
}